(* HTTP is an asymmetrical communication protocol that works with a concept of "server" and "client"
   The specification is given here: https://www.ietf.org/rfc/rfc2616.txt *)
module Http =

  type httpresponse =
    {
      httpbody: string;
      httpresponseheaders: string; (*httpresponseheaders;*)
    }
    
  type httpdecodedresponse = 
      Uncomplete 
    | FullResponse of string * string (*httpresponse TODO: need pattern matching of records *) 
    | Httperror of int



  let fail msg =
    printf "failure: %s\n" msg;
    Posix.exit 1
  
  

(* NOTE: we're not waiting for the end of the response, a general implementation would have to fetch everything *)
let decodehttpresponse s =
  if String.length s >= 12 && (String.prefix s 12 = "HTTP/1.1 200" || String.prefix s 12 = "HTTP/1.0 200") then
    case String.indexof "\r\n\r\n" s 
     | Some pos_separator ->
        let headers_block = String.prefix s (pos_separator + 4) in
        (*printf "\nheaders block:\n%s\n" headers_block;*)
        (*let response = { httpbody = String.suffix s (pos_separator + 4); httpresponseheaders = headers_block } in *)
        let response = (String.suffix s (pos_separator + 4), headers_block) in 
        FullResponse response
        

     | None -> Uncomplete
    end
  else
    Uncomplete

  (* a function to do a synchronous request to an http server *)
  let request_sync  fullrequest  (* a string, the full bytestream of the request *)
                    remoteaddr (* the socket address of the server *) =
    let socket = Posix.socket  Posix.AF_INET  Posix.SOCK_STREAM  0  in
    let ret = Posix.connect socket remoteaddr in
    if ret < 0 then fail "connect() failed\n" else ();
    
    let ret = Posix.send socket fullrequest 0 (String.length fullrequest) in
    if ret < String.length fullrequest then fail (sprintf "send() failed with return code %i\n" ret) else ();

    let buf = String.build 16384 in 
    let ret = Posix.recv socket buf 0 16384 in
    (*printf "recv ret: %i\n" ret;*)
    let s = String.sub buf 0 ret in
    let response = decodehttpresponse (String.sub buf 0 ret) in 
    case response
     | FullResponse (body, _) -> body
     | Uncomplete -> ""
     | Httperror err -> "error"
    end


endmodule